﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IInitialKeyboardIndicatorsStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class InitialKeyboardIndicatorsDefaultStrategy : ICorrespondenceOS, IInitialKeyboardIndicatorsStrategy
    {
        public InitialKeyboardIndicatorsDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "InitialKeyboardIndicators";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Control Panel\Keyboard");

            registryKey.SetValue(RegName, i.ToString());
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Control Panel\Keyboard");

            return new WFRegistry(@"HKEY_CURRENT_USER\Control Panel\Keyboard", RegName,
                              registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class InitialKeyboardIndicatorsController
    {
        public InitialKeyboardIndicatorsController(InitialKeyboardIndicators initialKeyboardIndicators,
                                                         IInitialKeyboardIndicatorsStrategy strategy)
        {
            InitialKeyboardIndicators = initialKeyboardIndicators;
            Strategy = strategy;
        }

        public InitialKeyboardIndicators InitialKeyboardIndicators { get; set; }
        public IInitialKeyboardIndicatorsStrategy Strategy { get; set; }

        public void Read()
        {
            InitialKeyboardIndicators.SetInitialKeyboardIndicatorsState(Convert.ToInt32(Strategy.Read().Value) == 0 ? false : true);
        }

        public void Write()
        {
            Strategy.Write(InitialKeyboardIndicators.GetInitialKeyboardIndicatorsState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
